<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Block\Adminhtml\Registration;

use Magento\Backend\Block\Template\Context;
use Magento\Backend\Helper\Data;
use Webarian\Workshop\Model\Registration;
use Webarian\Workshop\Model\ResourceModel\Registration\CollectionFactory;
use Magento\Framework\View\Model\PageLayout\Config\BuilderInterface;

class Grid extends \Magento\Backend\Block\Widget\Grid\Extended
{
	protected $_collectionFactory;

	protected $_registration;

	protected $_pageLayoutBuilder;

	public function __construct(
		Context $context,
		Data $backendHelper,
		Registration $registration,
		CollectionFactory $collectionFactory,
		BuilderInterface $pageLayoutBuilder,
		array $data = []
	) {
		$this->_collectionFactory = $collectionFactory;
		$this->_registration = $registration;
		$this->_pageLayoutBuilder = $pageLayoutBuilder;
		parent::__construct($context, $backendHelper, $data);
	}

	public function _construct()
	{	
		parent::_construct();
		$this->setId('registrationGrid');
		$this->setDefaultSort('id');
		$this->setDefaultDir('ASC');
	}

	protected function _prepareCollection()
	{
		$collection = $this->_collectionFactory->create();
		/* @var $collection \Magento\Cms\Model\ResourceModel\Page\Collection */
		$this->setCollection($collection);

		return parent::_prepareCollection();
	}

	protected function _prepareColumns()
	{
		$this->addColumn(
			'id',
			[
				'header'    => __('Registration ID'),
				'index'     => 'id',
			]
		);

		$this->addColumn(
			'name',
			[
				'header'    => __('Name'),
				'index'     => 'name'
			]
		);

		$this->addColumn(
			'email',
			[
				'header'    => __('Email'),
				'index'     => 'email'
			]
		);

		$this->addColumn(
			'phone_number',
			[
				'header'    => __('Phone Number'),
				'index'     => 'phone_number'
			]
		);
		
		$this->addColumn(
			'address',
			[
				'header'    => __('Address'),
				'index'     => 'address'
			]
		);

		$this->addColumn(
			'status',
			[
				'header'    => __('Payment Status'),
				'index'     => 'status'
			]
		);

		$this->addColumn(
			'workshop_id',
			[
				'header'    => __('Workshop'),
				'index'     => 'workshop_id',
				'filter'    => false,
				'renderer' => 'Webarian\Workshop\Block\Adminhtml\Registration\Grid\Renderer\Workshop'
			]
		);

		parent::_prepareColumns();
	}

	/**
	 * @return $this
	 */
	protected function _prepareMassaction()
	{
		$this->setMassactionIdField('id');
		$this->getMassactionBlock()->setFormFieldName('registration_param');

		$this->getMassactionBlock()->addItem(
			'delete',
			[
				'label' => __('Delete'),
				'url' => $this->getUrl('workshop/*/massDelete'),
				'confirm' => __('Are you sure?')
			]
		);

		$statuses = $this->_registration->getAvailableStatuses();

		array_unshift($statuses, ['label' => '', 'value' => '']);
		$this->getMassactionBlock()->addItem(
			'status',
			[
				'label' => __('Change Status'),
				'url' => $this->getUrl('workshop/*/massStatus', ['_current' => true]),
				'additional' => [
					'visibility' => [
						'name' => 'status',
						'type' => 'select',
						'class' => 'required-entry',
						'label' => __('Status'),
						'values' => $statuses
					]
				]
			]
		);

		return $this;
	}

	public function getRowUrl($row)
	{
		return null;
	}
}