<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Controller\Adminhtml;

use Magento\Backend\App\Action\Context;
use Magento\Framework\Registry;

abstract class Registration extends \Magento\Backend\App\Action
{
	protected $_coreRegistry = null;

	public function __construct(
		Context $context,
		Registry $registry
	)
	{
		$this->_coreRegistry = $registry;
		parent::__construct($context);
	}

	/**
	 * Init page
	 *
	 * @param \Magento\Backend\Model\View\Result\Page $resultPage
	 * @return \Magento\Backend\Model\View\Result\Page
	 */
	protected function _initAction($resultPage)
	{
		$resultPage->setActiveMenu('Webarian_Workshop::workshop_registration');
		$resultPage->addBreadcrumb(__('Workshop Manager'), __('Workshop Registration Manager'))
			->addBreadcrumb(__('Workshop Registration'), __('Workshop Registration'));
		return $resultPage;
	}

	protected function _isAllowed()
	{
		return $this->_authorization->isAllowed('Webarian_Workshop::save');
	}
}