<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Controller\Adminhtml\Registration;

use Magento\Framework\Controller\ResultFactory;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Registry;
use Webarian\Workshop\Model\RegistrationFactory;

class MassDelete extends \Magento\Backend\App\Action
{
	protected $_coreRegistry;
	protected $query;
	protected $_registrationFactory;
	protected $productRepository;

	public function __construct(
		Context $context,
		Registry $registry,
		RegistrationFactory $registrationFactory,
		\Magento\Catalog\Model\ProductRepository $productRepository
	)
	{
		$this->_coreRegistry = $registry;
		$this->_registrationFactory = $registrationFactory;
		$this->productRepository = $productRepository;
		parent::__construct($context);
	}

	public function execute(){

		$registrationIds = $this->getRequest()->getParam('workshop_param');
		$registrationObj = $this->_registrationFactory->create();

		$countRegistrationId = 0;

		if(!is_array($registrationIds)) {
			$this->messageManager->addError(__('Please select item(s)'));
		}
		else{
			try {
				foreach ($registrationIds as $registrationId) {
					$collection = $registrationObj->load($registrationId);
					$collection->delete();

					$countRegistrationId++;
				}

				$this->messageManager->addSuccess(
					__('A total of %1 record(s) have been deleted.', $countRegistrationId)
				);
				
			} catch (\Magento\Framework\Exception\LocalizedException $e) {
				$this->messageManager->addError($e->getMessage());
			} catch (\Exception $e) {
				$this->_getSession()->addException($e, __('Something went wrong while updating the product(s) status.'));
			}
			$redirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
			return $redirect->setPath('workshop/registration/index');
		}
	}
}