<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Controller\Adminhtml\Workshop;

use Magento\Framework\Controller\ResultFactory;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Registry;

class MassStatus extends \Webarian\Workshop\Controller\Adminhtml\Workshop
{
	protected $_coreRegistry;

	public function __construct(
		Context $context,
		Registry $registry
	)
	{
		$this->_coreRegistry = $registry;
		parent::__construct($context, $registry);
	}

	/**
	 * Update product(s) status action
	 *
	 * @return \Magento\Backend\Model\View\Result\Redirect
	 */
	public function execute(){
		$workshopIds = $this->getRequest()->getParam('workshop_param');
		$workshops = $this->_objectManager->create('Webarian\Workshop\Model\Workshop');
		$menuGroup = 0;
		if(!is_array($workshopIds)) {
			$this->messageManager->addError($this->__('Please select item(s)'));
		}
		else{
			try {
				foreach ($workshopIds as $workshop) {
					$workshops->load($workshop)
						->setStatus($this->getRequest()->getParam('status'))
						->setIsMassupdate(true)
						->save();
					$menuGroup++;
				}
				$this->messageManager->addSuccess(
					__('A total of %1 record(s) have been update status.', $menuGroup)
				);
				$redirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
				return $redirect->setPath('workshop/workshop/index');
			} catch (\Magento\Framework\Exception\LocalizedException $e) {
				$this->messageManager->addError($e->getMessage());
			} catch (\Exception $e) {
				$this->_getSession()->addException($e, __('Something went wrong while updating the product(s) status.'));
			}
		}
		$redirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
		return $redirect->setPath('workshop/*/index');
	}
}