<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Block\Adminhtml\Registration\Grid\Renderer;
use Webarian\Workshop\Model\WorkshopFactory;

class Workshop extends \Magento\Backend\Block\Widget\Grid\Column\Renderer\AbstractRenderer
{
    protected $_workshopFactory;

    public function __construct(
           WorkshopFactory $workshopFactory
    ) {
        $this->_workshopFactory = $workshopFactory;
    }

    /**
    * Renders grid column
    * @param \Magento\Framework\DataObject $row
    * @return string
    */
    public function render(\Magento\Framework\DataObject $row)
    {
        $workshopId = $row->getData('workshop_id');
        $workshop = $this->_workshopFactory->create()->load($workshopId);
        $title = '';
        if(!$workshop->getTitle()){
            $title = "removed";
        }else{
            $title = $workshop->getTitle();
        }
        return $title;
   
    }
}