<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Controller\Adminhtml\Registration;

use Magento\Backend\App\Action\Context;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;

class Index extends \Webarian\Workshop\Controller\Adminhtml\Registration
{
	protected $resultPageFactory;

	public function __construct(
		Context $context,
		Registry $coreRegistry,
		PageFactory $resultPageFactory
	)
	{
		$this->resultPageFactory = $resultPageFactory;
		parent::__construct($context, $coreRegistry);
	}

	public function execute()
	{	
		$resultPage = $this->resultPageFactory->create();
		$this->_initAction($resultPage)->getConfig()->getTitle()->prepend(__('Registration'));
		return $resultPage;
	}
}