<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Store\Model\ScopeInterface;

class Data extends AbstractHelper {

	const Webarian_Workshop_XML_PATH_EXTENSIONS = 'workshop/general/';

	protected $scopeConfig;
	
	protected $_storeManager;
	
	public function __construct(
		\Magento\Framework\View\Element\Context $context, 
		\Magento\Store\Model\StoreManagerInterface $storeManager
	)
    {
        $this->scopeConfig = $context->getScopeConfig();
		$this->_storeManager = $storeManager;
    }

    public function getModuleConfig($path, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $path,
            ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }

    public function chkIsModuleEnable(){

    	return $this->getModuleConfig(self::Webarian_Workshop_XML_PATH_EXTENSIONS . 'isenabled');
    }
}
