<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Model;

use Webarian\Workshop\Api\Data\RegistrationInterface;
use Magento\Framework\Model\AbstractModel;

class Registration extends AbstractModel implements RegistrationInterface
{
	const STATUS_ENABLED = 1;
	const STATUS_DISABLED = 2;

	protected function _construct()
	{
		$this->_init('Webarian\Workshop\Model\ResourceModel\Registration');
	}

	public function getRegistrationId()
	{
		return $this->getData(self::REGISTRATION_ID);
	}

	public function getUserName()
	{
		return $this->getData(self::NAME);
	}

	public function getEmail()
	{
		return $this->getData(self::EMAIL);
	}

	public function getPhoneNumber()
	{
		return $this->getData(self::PHONE_NUMBER);
	}

	public function getAddress()
	{
		return $this->getData(self::ADDRESS);
	}

	public function getStatus()
	{
		return $this->getData(self::STATUS);
	}

	public function setRegistrationId($registrationId)
	{
		return $this->setData(self::REGISTRATION_ID, $registrationId);
	}

	public function setUserName($name)
	{
		return $this->setData(self::NAME, $name);
	}

	public function setEmail($email)
	{
		return $this->setData(self::EMAIL, $email);
	}

	public function setPhoneNumber($phoneNumber)
	{
		return $this->setData(self::PHONE_NUMBER, $phoneNumber);
	}

	public function setAddress($address)
	{
		return $this->setData(self::ADDRESS, $address);
	}

	public function setStatus($status)
	{
		return $this->setData(self::STATUS, $status);
	}

	public function getAvailableStatuses()
	{
		return [self::STATUS_ENABLED => __('Enabled'), self::STATUS_DISABLED => __('Disabled')];
	}

}