<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Observer;

use Magento\Framework\Event\ObserverInterface;
use Webarian\Workshop\Model\RegistrationFactory;

class WorshopPaymentOnOrderSuccess implements ObserverInterface
{
    /**
     * @var \Magento\Sales\Model\OrderFactory
     */
    protected $orderModel;

    /**
     * @var \Magento\Sales\Model\Order\Email\Sender\OrderSender
     */
    protected $orderSender;

    /**
     * @var \Magento\Checkout\Model\Session $checkoutSession
     */
    protected $checkoutSession;
    protected $helperData;

    protected $_request;
    protected $_layout;
    protected $_objectManager = null;
    private $responseFactory;
    private $url;
    protected $_registrationFactory;

    /**
     * @param \Magento\Sales\Model\OrderFactory $orderModel
     * @param \Magento\Sales\Model\Order\Email\Sender\OrderSender $orderSender
     * @param \Magento\Checkout\Model\Session $checkoutSession
     *
     * @codeCoverageIgnore
     */
    public function __construct(
        \Magento\Sales\Model\OrderFactory $orderModel,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Webarian\Workshop\Helper\Data $helperData,
        \Magento\Framework\View\Element\Context $context,
        \Magento\Framework\ObjectManagerInterface $objectManager,
       \Magento\Framework\App\ResponseFactory $responseFactory,
       RegistrationFactory $registrationFactory
    )
    {
        $this->orderModel = $orderModel;
        $this->checkoutSession = $checkoutSession;
        $this->helperData = $helperData;

        $this->_layout = $context->getLayout();
        $this->_request = $context->getRequest();
        $this->_objectManager = $objectManager;
        $this->responseFactory = $responseFactory;
        $this->_registrationFactory = $registrationFactory;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if($this->helperData->chkIsModuleEnable()) {
            $orderIds = $observer->getEvent()->getOrderIds();
            if (count($orderIds)) {
                $orderId =  $orderIds[0];
                $order = $this->orderModel->create()->load($orderId);
                $quoteId = $order->getQuoteId();

                $registerObj = $this->_registrationFactory->create();
                $registerColl = $registerObj->getCollection()
                                        ->addFieldToFilter('quote_id', $quoteId);
                if($registerColl->getSize() > 0){
                    $FirstItem = $registerColl->getFirstItem();
                    $registrationId = $FirstItem->getData('id');
                    $registerObj->load($registrationId);
                }
                                        
                $registerObj->setData('status', 'paid');
                $registerObj->save();
                //exit();
                return $this;
            }
        }
    }
}