<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Controller\Adminhtml\Workshop;

class Delete extends \Webarian\Workshop\Controller\Adminhtml\Workshop
{
	/**
	 * Delete action
	 *
	 * @return \Magento\Backend\Model\View\Result\Redirect
	 */
	public function execute()
	{
		// check if we know what should be deleted
		$id = $this->getRequest()->getParam('workshop_id');
		/** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
		$resultRedirect = $this->resultRedirectFactory->create();
		if ($id) {
			try {
				// init model and delete
				$model = $this->_objectManager->create('Webarian\Workshop\Model\Workshop');
				$product = $this->_objectManager->create('Magento\Catalog\Model\Product');
				
				$workshopItems= $this->_objectManager->create('Webarian\Workshop\Model\Workshop');
				$model->load($id);
				$productId = $model->getData('product_id');
				$model->delete();

				$product->load($productId)->delete();
				// display success message
				$this->messageManager->addSuccess(__('You deleted the workshop.'));
				// go to grid
				return $resultRedirect->setPath('*/*/');
			}
			catch (\Exception $e)
			{
				// display error message
				$this->messageManager->addError($e->getMessage());
				// go back to edit form
				return $resultRedirect->setPath('*/*/edit', ['id' => $id]);
			}
		}
		// display error message
		$this->messageManager->addError(__('We can\'t find a workshop to delete.'));
		// go to grid
		return $resultRedirect->setPath('*/*/');
	}
}