<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Controller\Register;

use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\View\Result\PageFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\Message\ManagerInterface;

class Index extends \Magento\Framework\App\Action\Action
{
    protected $_resultPageFactory;
    protected $_storeManager;
    protected $_messageManager;

    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        StoreManagerInterface $storeManager,
        ManagerInterface $messageManager
    ) {
        $this->_resultPageFactory = $resultPageFactory;
        $this->_storeManager = $storeManager;
        $this->_messageManager = $messageManager;
        parent::__construct($context);
    }

    public function execute()
    {
        $redirectUrl = $this->_redirect->getRefererUrl();
        $baseUrl = $this->_storeManager->getStore()->getBaseUrl();
        $temp = 0;
        $urlparts = explode($baseUrl, $redirectUrl);
        if (isset($urlparts[1]) && $urlparts[1] != "") {
            $module = trim($urlparts[1], "/");
            if ($module == "workshop") {
                $resultPage = $this->_resultPageFactory->create();
                return $resultPage;
            } else {
                $temp = 1;
            }
        } else {
            $temp = 1;
        }
        if ($temp) {
            $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
            // $this->_messageManager->addError(__("Register workshop from here !!"));
            return $resultRedirect->setPath('workshop');
        }
    }
}
