<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Model;

use Webarian\Workshop\Api\Data\WorkshopInterface;
use Magento\Framework\Model\AbstractModel;

class Workshop extends AbstractModel implements WorkshopInterface
{
	const STATUS_ENABLED = 1;
	const STATUS_DISABLED = 2;

	protected function _construct()
	{
		$this->_init('Webarian\Workshop\Model\ResourceModel\Workshop');
	}

	public function getWorkshopId()
	{
		return $this->getData(self::WORKSHOP_ID);
	}

	public function getTitle()
	{
		return $this->getData(self::TITLE);
	}

	public function getDate()
	{
		return $this->getData(self::DATE);
	}

	public function getDuration()
	{
		return $this->getData(self::DURATION);
	}

	public function getAge()
	{
		return $this->getData(self::AGE);
	}

	public function getPrice()
	{
		return $this->getData(self::PRICE);
	}

	public function getAddress()
	{
		return $this->getData(self::ADDRESS);
	}

	public function getProductId()
	{
		return $this->getData(self::PRODUCT_ID);
	}

	public function getStatus()
	{
		return $this->getData(self::STATUS);
	}

	public function setWorkshopId($workshopId)
	{
		return $this->setData(self::WORKSHOP_ID, $workshopId);
	}

	public function setTitle($title)
	{
		return $this->setData(self::TITLE, $title);
	}

	public function setDate($date)
	{
		return $this->setData(self::DATE, $date);
	}

	public function setDuration($duration)
	{
		return $this->setData(self::DURATION, $duration);
	}

	public function setAge($age)
	{
		return $this->setData(self::AGE, $age);
	}
	
	public function setPrice($price)
	{
		return $this->setData(self::PRICE, $price);
	}

	public function setAddress($address)
	{
		return $this->setData(self::ADDRESS, $address);
	}

	public function setProductId($productId)
	{
		return $this->setData(self::PRODUCT_ID, $productId);
	}
	public function setStatus($status)
	{
		return $this->setData(self::STATUS, $status);
	}

	public function getAvailableStatuses()
	{
		return [self::STATUS_ENABLED => __('Enabled'), self::STATUS_DISABLED => __('Disabled')];
	}

}