<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Block\Adminhtml;

class Workshop extends \Magento\Backend\Block\Widget\Grid\Container
{

	protected function _construct()
	{	
		$this->_blockGroup = 'Webarian_Workshop';
		$this->_controller = 'adminhtml_workshop';
		$this->_headerText = __('Workshop Manager');
		parent::_construct();

		if ($this->_isAllowedAction('Webarian_Workshop::save')) {
			$this->buttonList->update('add', 'label', __('Add Workshop'));
		} else {
			$this->buttonList->remove('add');
		}
	}

	protected function _isAllowedAction($resourceId)
	{
		return $this->_authorization->isAllowed($resourceId);
	}
}