<?php

namespace Webarian\Workshop\Block\Adminhtml\Workshop\Edit\Tab;

use Magento\Backend\Block\Template\Context;
use Magento\Framework\Registry;
use Magento\Framework\Data\FormFactory;
use Magento\Store\Model\System\Store;
use Magento\Framework\Locale\ResolverInterface;

class Form extends \Magento\Backend\Block\Widget\Form\Generic implements
    \Magento\Backend\Block\Widget\Tab\TabInterface
{
	protected $_systemStore;
	protected $_localeDate;

	public function __construct(
		Context $context,
		Registry $registry,
		FormFactory $formFactory,
		Store $systemStore,
		ResolverInterface $resolverInterface,
		array $data = []
	) {
		$this->_systemStore = $systemStore;
		$this->_localeDate = $resolverInterface;
		parent::__construct($context, $registry, $formFactory, $data);
	}

	protected function _prepareForm()
	{	
		$model = $this->_coreRegistry->registry('workshop_workshop');
		//echo "<pre>"; print_r($model->getData());die;
		/*
         * Checking if user have permissions to save information
         */
		if ($this->_isAllowedAction('Webarian_Workshop::save')) {
			$isElementDisabled = false;
		} else {
			$isElementDisabled = true;
		}

		/** @var \Magento\Framework\Data\Form $form */
		$form = $this->_formFactory->create();

		$fieldset = $form->addFieldset('base_fieldset', ['legend' => __('Workshop Information')]);

		$eventDate = '';
		if ($model->getId()) {
			$fieldset->addField('workshop_id', 'hidden', ['name' => 'workshop_id']);
			$eventDate = $model->getDate();
		}

		$fieldset->addField(
			'title',
			'text',
			[
				'name' => 'title',
				'label' => __('Title'),
				'title' => __('Title'),
				'id' => 'title',
				'class' => 'title validate-alphanum-with-spaces',
				'required' => true,
				'disabled' => $isElementDisabled
			]
		);

		$publishDate = $fieldset->addField(
			'date',
			'date',
			[
				'name' => 'date',
				'label' => __('Date'),
				'title' => __('Date'),
				'id' => 'date',
				'class' => 'datepicker',
				'required' => true,
				'readonly' => true,
				//'date_format' => $this->_localeDate->getDateFormat(\IntlDateFormatter::SHORT),
				'date_format' => 'M/d/yyyy',
				'disabled' => $isElementDisabled,
				'note'      => __('Date Format: mm/dd/yyyy')
			]
		);

		$fieldset->addField(
			'duration',
			'text',
			[
				'name' => 'duration',
				'label' => __('Duration'),
				'title' => __('Duration'),
				'id' => 'duration',
				'class' => 'duration',
				'required' => true,
				'disabled' => $isElementDisabled
			]
		);

		$fieldset->addField(
			'capacity',
			'text',
			[
				'name' => 'capacity',
				'label' => __('Capacity'),
				'title' => __('Capacity'),
				'id' => 'capacity',
				'class' => 'capacity validate-number',
				'required' => true,
				'disabled' => $isElementDisabled
			]
		);

		$fieldset->addField(
			'age',
			'text',
			[
				'name' => 'age',
				'label' => __('Age'),
				'title' => __('Age'),
				'id' => 'age',
				'class' => 'age validate-number',
				'required' => true,
				'disabled' => $isElementDisabled
			]
		);

		$fieldset->addField(
			'price',
			'text',
			[
				'name' => 'price',
				'label' => __('Ticket Price'),
				'title' => __('Ticket Price'),
				'id' => 'price',
				'class' => 'price',
				'required' => true,
				'disabled' => $isElementDisabled
			]
		);

		$fieldset->addField(
			'address',
			'textarea',
			[
				'name' => 'address',
				'label' => __('Address'),
				'title' => __('Address'),
				'id' => 'address',
				'class' => 'address validate-alphanum-with-spaces',
				'required' => false,
				'disabled' => $isElementDisabled
			]
		);

		// $fieldset->addField(
		// 	'banner',
		// 	'image',
		// 	[
		// 		'name' => 'banner',
		// 		'label' => __('Image'),
		// 		'title' => __('Image'),
		// 		'required'  => false,
		// 		'disabled' => $isElementDisabled
		// 	]
		// );
		
		
		$fieldset->addField(
			'status',
			'select',
			[
				'label'     => __('Status'),
				'title'     => __('Workshop Status'),
				'name'      => 'status',
				'required'  => false,
				'options'   => $model->getAvailableStatuses(),
				'disabled'  => $isElementDisabled
			]
		);

		$publishDate->setAfterElementHtml("
			<script type=\"text/javascript\">

				require([
				'jquery',
				'mage/template',
				'jquery/ui',
				'mage/translate',
				'mage/calendar'
				],
				function($, mageTemplate) {
					//alert(date+'/'+month+'/'+year);
					$('#container .admin__scope-old').addClass('admin__scope-new');
					$('#container .admin__scope-old').removeClass('admin__scope-old');

					$('#date').calendar({
			            showsTime: false,
			            hideIfNoPrevNext: true,
			            buttonText: '".__('Select Date') ."',
			            minDate: new Date(),
			            dateFormat: 'M/d/y'
			        });
				});
				
			</script>
		");

		if (!$model->getId()) {
			$model->setData('status', $isElementDisabled ? '0' : '1');
		}
		$this->_eventManager->dispatch('adminhtml_workshop_edit_tab_form_prepare_form', ['form' => $form]);

		$form->setValues($model->getData());
		$this->setForm($form);

		parent::_prepareForm();
	}

	/**
	 * Prepare label for tab
	 *
	 * @return \Magento\Framework\Phrase
	 */
	public function getTabLabel()
	{
		return __('Workshop');
	}

	/**
	 * Prepare title for tab
	 *
	 * @return \Magento\Framework\Phrase
	 */
	public function getTabTitle()
	{
		return __('Workshop');
	}

	/**
	 * {@inheritdoc}
	 */
	public function canShowTab()
	{
		return true;
	}

	/**
	 * {@inheritdoc}
	 */
	public function isHidden()
	{
		return false;
	}

	/**
	 * Check permission for passed action
	 *
	 * @param string $resourceId
	 * @return bool
	 */
	protected function _isAllowedAction($resourceId)
	{
		return $this->_authorization->isAllowed($resourceId);
	}
}