<?php

namespace Webarian\Workshop\Block\Adminhtml\Workshop;

use Magento\Backend\Block\Template\Context;
use Magento\Backend\Helper\Data;
use Webarian\Workshop\Model\Workshop;
use Webarian\Workshop\Model\ResourceModel\Workshop\CollectionFactory;
use Magento\Framework\View\Model\PageLayout\Config\BuilderInterface;

class Grid extends \Magento\Backend\Block\Widget\Grid\Extended
{
	protected $_collectionFactory;

	protected $_workshop;

	protected $_pageLayoutBuilder;

	public function __construct(
		Context $context,
		Data $backendHelper,
		Workshop $workshop,
		CollectionFactory $collectionFactory,
		BuilderInterface $pageLayoutBuilder,
		array $data = []
	) {
		$this->_collectionFactory = $collectionFactory;
		$this->_workshop = $workshop;
		$this->_pageLayoutBuilder = $pageLayoutBuilder;
		parent::__construct($context, $backendHelper, $data);
	}

	public function _construct()
	{	
		parent::_construct();
		$this->setId('workshopGrid');
		$this->setDefaultSort('workshop_id');
		$this->setDefaultDir('ASC');
	}

	protected function _prepareCollection()
	{
		$collection = $this->_collectionFactory->create();
		/* @var $collection \Magento\Cms\Model\ResourceModel\Page\Collection */
		$this->setCollection($collection);

		return parent::_prepareCollection();
	}

	protected function _prepareColumns()
	{
		$this->addColumn(
			'workshop_id',
			[
				'header'    => __('Workshop ID'),
				'index'     => 'workshop_id',
			]
		);

		$this->addColumn(
			'title',
			[
				'header'    => __('Title'),
				'index'     => 'title'
			]
		);

		$this->addColumn(
			'date',
			[
				'header'    => __('Date'),
				'index'     => 'date'
			]
		);

		$this->addColumn(
			'duration',
			[
				'header'    => __('Duration'),
				'index'     => 'duration'
			]
		);

		$this->addColumn(
			'capacity',
			[
				'header'    => __('Capacity'),
				'index'     => 'capacity'
			]
		);

		$this->addColumn(
			'age',
			[
				'header'    => __('Age'),
				'index'     => 'age'
			]
		);

		$this->addColumn(
			'price',
			[
				'header'    => __('Ticket Price'),
				'index'     => 'price'
			]
		);

		
		$this->addColumn(
			'address',
			[
				'header'    => __('Address'),
				'index'     => 'address'
			]
		);

		$this->addColumn(
			'product_id',
			[
				'header'    => __('Product Id'),
				'index'     => 'product_id'
			]
		);

		// $this->addColumn(
        //     'banner',
        //     [
        //         'header'    => __('Banner Image'),
        //         'index'     => 'banner',
        //         'width'     => '100px',
        //     ]
        // );

		$this->addColumn(
			'status',
			[
				'header'    => __('Status'),
				'index'     => 'status',
				'type' => 'options',
				'options' => $this->_workshop->getAvailableStatuses()
			]
		);

		$this->addColumn(
			'workshop_actions',
			[
				'header' => __('Action'),
				'type' => 'action',
				'getter' => 'getId',
				'actions' => [
					[
						'caption' => __('Edit'),
						'url' => [
							'base' => '*/*/edit',
							'params' => ['store' => $this->getRequest()->getParam('store')]
						],
						'field' => 'id'
					]
				],
				'sortable' => false,
				'filter' => false,
				'index' => 'stores',
				'header_css_class' => 'col-action',
				'column_css_class' => 'col-action'
			]
		);

		parent::_prepareColumns();
	}

	/**
	 * @return $this
	 */
	protected function _prepareMassaction()
	{
		$this->setMassactionIdField('workshop_id');
		$this->getMassactionBlock()->setFormFieldName('workshop_param');

		$this->getMassactionBlock()->addItem(
			'delete',
			[
				'label' => __('Delete'),
				'url' => $this->getUrl('workshop/*/massDelete'),
				'confirm' => __('Are you sure?')
			]
		);

		$statuses = $this->_workshop->getAvailableStatuses();

		array_unshift($statuses, ['label' => '', 'value' => '']);
		$this->getMassactionBlock()->addItem(
			'status',
			[
				'label' => __('Change Status'),
				'url' => $this->getUrl('workshop/*/massStatus', ['_current' => true]),
				'additional' => [
					'visibility' => [
						'name' => 'status',
						'type' => 'select',
						'class' => 'required-entry',
						'label' => __('Status'),
						'values' => $statuses
					]
				]
			]
		);

		return $this;
	}

	public function getRowUrl($row)
	{
		return $this->getUrl('*/*/edit', ['id' => $row->getId()]);
	}
}