<?php
/**
 * @author    Webarian Team
 * @copyright Copyright (c) 2020 Webarian (https://www.webariansoftwares.com/)
 * @package   Webarian_PromoPopup
 */
namespace Webarian\Workshop\Block;
use Magento\Backend\Block\Template\Context;
use Webarian\Workshop\Helper\Data;
use Webarian\Workshop\Model\WorkshopFactory;

class Workshop extends \Magento\Framework\View\Element\Template
{
	protected $_workshopFactory;
	protected $_helper;

	public function __construct(
		Context $context,
		Data $helper,
		WorkshopFactory $workshopFactory
	) {
		$this->_workshopFactory = $workshopFactory;
		$this->_helper = $helper;
		parent::__construct($context);
	}

    public function getCollection()
    {
    	$collection = $this->_workshopFactory->create()->getCollection()->addFieldToFilter('status', 1);
        return $collection;
    }

    public function getWorkshopTitle()
    {
    	$workshopId = $this->getRequest()->getParam('id');
    	$workshop = $this->_workshopFactory->create()->load($workshopId);
        return $workshop->getTitle();
    }
}